<?php
session_start();

// Validate that we have payment response data
if(empty($_POST)) {
    // No POST data received, redirect to error page
    $returnUrl = isset($_SESSION['return_url']) ? $_SESSION['return_url'] : '/dashboard/index.php';
    header("location: " . $returnUrl . "?error=no_payment_response");
    exit;
}

$paytmResponse = $_POST;

// Log the response for debugging
error_log(date('Y-m-d H:i:s') . " - Payment gateway response received - OrderID: " . (isset($_POST['ORDERID']) ? $_POST['ORDERID'] : 'N/A') . "\n", 3, __DIR__ . '/payment_success.log');
?>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processing Payment Response</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            text-align: center;
            max-width: 500px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 24px;
        }
        .loader {
            border: 5px solid #f3f3f3;
            border-top: 5px solid #667eea;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        p {
            color: #666;
            font-size: 14px;
            line-height: 1.6;
        }
        .warning {
            color: #ff6b6b;
            font-weight: bold;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Transaction is being processed</h1>
        <div class="loader"></div>
        <p>Please wait while we verify your payment...</p>
        <p class="warning">Please do not press 'Refresh' or 'Back' button</p>
    </div>
    
    <form name="responseForm" action="<?php echo isset($_SESSION['baseurl']) ? $_SESSION['baseurl'] : ''; ?>/payment/payment-response.php" method="POST">
        <?php
        foreach ($paytmResponse as $name => $value) {
            echo '<input type="hidden" name="' . htmlspecialchars($name) . '" value="' . htmlspecialchars($value) . '">';
        }
        ?>
    </form>
    
    <script type="text/javascript">
        // Auto-submit form after 1 second
        setTimeout(function() {
            document.forms['responseForm'].submit();
        }, 1000);
    </script>
</body>
</html>
