<?php
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/payment_errors.log');

include '../config.php'; 
require_once('lib/Config_HBConnect.php');
require_once('lib/RechPayChecksum.php');

// Function to log errors
function logPaymentError($message, $data = array()) {
    $logMessage = date('Y-m-d H:i:s') . " - " . $message . " - " . json_encode($data) . "\n";
    error_log($logMessage, 3, __DIR__ . '/payment_errors.log');
}

// Function to log successful transactions
function logPaymentSuccess($message, $data = array()) {
    $logMessage = date('Y-m-d H:i:s') . " - SUCCESS - " . $message . " - " . json_encode($data) . "\n";
    error_log($logMessage, 3, __DIR__ . '/payment_success.log');
}

$array = array();
$status = isset($_POST['status']) ? $_POST['status'] : '';
$txnAmount = isset($_POST['txnAmount']) ? $_POST['txnAmount'] : '';
$message = isset($_POST['message']) ? $_POST['message'] : '';
$hash = isset($_POST['hash']) ? $_POST['hash'] : '';
$checksum = isset($_POST['checksum']) ? $_POST['checksum'] : '';

// Log incoming request
logPaymentError("Payment callback received", $_POST);

if($status == "SUCCESS") {
    try {
        $paramList = hash_decrypt($hash, $secret);
        $verifySignature = RechPayChecksum::verifySignature($paramList, $secret, $checksum);
        
        if($verifySignature) {
            $array = json_decode($paramList, true);
            
            // Sanitize inputs
            $userid = mysqli_real_escape_string($connection, $array["sender_note"]);
            $amt = floatval($array["txnAmount"]);
            $orderId = mysqli_real_escape_string($connection, $array["orderId"]);
            $bankTxnId = mysqli_real_escape_string($connection, $array["bankTxnId"]);
            $txnStatus = mysqli_real_escape_string($connection, $array["txnStatus"]);
            $paymentMode = mysqli_real_escape_string($connection, $array["paymentMode"]);
            $status = mysqli_real_escape_string($connection, $array["status"]);
            $txnDate = mysqli_real_escape_string($connection, $array["txnDate"]);
            
            // Check if transaction already processed
            $checkQuery = "SELECT * FROM payment_transactions WHERE order_id = '$orderId' AND bank_txn_id = '$bankTxnId'";
            $checkResult = mysqli_query($connection, $checkQuery);
            
            if(mysqli_num_rows($checkResult) > 0) {
                logPaymentError("Duplicate transaction attempt blocked", array('orderId' => $orderId, 'bankTxnId' => $bankTxnId));
                
                $html = '
                <html>
                  <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
                  </head>
                    <style>
                      body {
                        text-align: center;
                        padding: 40px 0;
                        background: #EBF0F5;
                      }
                        h1 {
                          color: #88B04B;
                          font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                          font-weight: 900;
                          font-size: 40px;
                          margin-bottom: 10px;
                        }
                        p {
                          color: #404F5E;
                          font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                          font-size:20px;
                          margin: 0;
                        }
                      i {
                        color: #9ABC66;
                        font-size: 100px;
                        line-height: 200px;
                        margin-left:-15px;
                      }
                      .card {
                        background: white;
                        padding: 60px;
                        border-radius: 4px;
                        box-shadow: 0 2px 3px #C8D0D8;
                        display: inline-block;
                        margin: 0 auto;
                      }
                    </style>
                    <body>
                      <div class="card">
                      <div style="border-radius:200px; height:200px; width:200px; background: #F8FAF5; margin:0 auto;">
                        <i class="checkmark">✓</i>
                      </div>
                        <h1>Already Processed</h1> 
                        <p>This payment has already been processed!<br/> Your wallet was already updated.</p>
                      </div>
                    </body>
                </html>
                ';
                echo $html;
                ?>
                <script>
                    setTimeout(()=>{
                        window.location.href="https://dc.crsorgi.gov.in.web.verfy.in/dashboard/wallet.php";
                    }, 2000);
                </script>
                <?php
                exit;
            }
            
            // Start transaction for atomic operations
            mysqli_begin_transaction($connection);
            
            try {
                // Insert transaction record first
                $insertTxnQuery = "INSERT INTO payment_transactions 
                    (user_id, order_id, bank_txn_id, amount, payment_mode, txn_status, txn_date, response_data, created_at) 
                    VALUES 
                    ('$userid', '$orderId', '$bankTxnId', '$amt', '$paymentMode', '$txnStatus', '$txnDate', '" . json_encode($array) . "', NOW())";
                
                if(!mysqli_query($connection, $insertTxnQuery)) {
                    throw new Exception("Failed to insert transaction: " . mysqli_error($connection));
                }
                
                // Update wallet amount
                $updateWalletQuery = "UPDATE usertable SET walletamount = walletamount + $amt WHERE userid = '$userid'";
                
                if(!mysqli_query($connection, $updateWalletQuery)) {
                    throw new Exception("Failed to update wallet: " . mysqli_error($connection));
                }
                
                // Check if wallet was actually updated
                if(mysqli_affected_rows($connection) == 0) {
                    throw new Exception("No user found with userid: " . $userid);
                }
                
                // Commit transaction
                mysqli_commit($connection);
                
                // Log success
                logPaymentSuccess("Wallet updated successfully", array(
                    'userid' => $userid,
                    'amount' => $amt,
                    'orderId' => $orderId,
                    'bankTxnId' => $bankTxnId
                ));
                
                $html = '
                <html>
                  <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
                  </head>
                    <style>
                      body {
                        text-align: center;
                        padding: 40px 0;
                        background: #EBF0F5;
                      }
                        h1 {
                          color: #88B04B;
                          font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                          font-weight: 900;
                          font-size: 40px;
                          margin-bottom: 10px;
                        }
                        p {
                          color: #404F5E;
                          font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                          font-size:20px;
                          margin: 0;
                        }
                      i {
                        color: #9ABC66;
                        font-size: 100px;
                        line-height: 200px;
                        margin-left:-15px;
                      }
                      .card {
                        background: white;
                        padding: 60px;
                        border-radius: 4px;
                        box-shadow: 0 2px 3px #C8D0D8;
                        display: inline-block;
                        margin: 0 auto;
                      }
                    </style>
                    <body>
                      <div class="card">
                      <div style="border-radius:200px; height:200px; width:200px; background: #F8FAF5; margin:0 auto;">
                        <i class="checkmark">✓</i>
                      </div>
                        <h1>Success</h1> 
                        <p>We Got Your Payment 👍!!<br/> Wallet Updated Successfully !</p>
                      </div>
                    </body>
                </html>
                ';
                echo $html;
                
            } catch(Exception $e) {
                // Rollback on error
                mysqli_rollback($connection);
                logPaymentError("Transaction failed: " . $e->getMessage(), array(
                    'userid' => $userid,
                    'orderId' => $orderId,
                    'error' => $e->getMessage()
                ));
                
                $html = '
                <html>
                  <head>
                    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
                  </head>
                    <style>
                      body {
                        text-align: center;
                        padding: 40px 0;
                        background: #EBF0F5;
                      }
                        h1 {
                          color: #f20101;
                          font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                          font-weight: 900;
                          font-size: 40px;
                          margin-bottom: 10px;
                        }
                        p {
                          color: #404F5E;
                          font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                          font-size:20px;
                          margin: 0;
                        }
                      .card {
                        background: white;
                        padding: 60px;
                        border-radius: 4px;
                        box-shadow: 0 2px 3px #C8D0D8;
                        display: inline-block;
                        margin: 0 auto;
                      }
                    </style>
                    <body>
                      <div class="card">
                        <h1>Processing Error</h1> 
                        <p>Payment received but wallet update failed!<br/>Please contact support with Order ID: ' . htmlspecialchars($orderId) . '</p>
                      </div>
                    </body>
                </html>
                ';
                echo $html;
            }
            ?>
            <script>
                setTimeout(()=>{
                    window.location.href="https://dc.crsorgi.gov.in.web.verfy.in/dashboard/wallet.php";
                }, 3000);
            </script>
            <?php
        } else {
            logPaymentError("Signature verification failed", array('hash' => $hash));
            
            $html = '
            <html>
              <head>
                <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
              </head>
                <style>
                  body {
                    text-align: center;
                    padding: 40px 0;
                    background: #EBF0F5;
                  }
                    h1 {
                      color: #f20101;
                      font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                      font-weight: 900;
                      font-size: 40px;
                      margin-bottom: 10px;
                    }
                    p {
                      color: #404F5E;
                      font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                      font-size:20px;
                      margin: 0;
                    }
                  .card {
                    background: white;
                    padding: 60px;
                    border-radius: 4px;
                    box-shadow: 0 2px 3px #C8D0D8;
                    display: inline-block;
                    margin: 0 auto;
                  }
                </style>
                <body>
                  <div class="card">
                    <h1>Verification Failed</h1> 
                    <p>Invalid payment signature!<br/>Please contact support.</p>
                  </div>
                </body>
            </html>
            ';
            echo $html;
            ?>
            <script>
                setTimeout(()=>{
                    window.location.href="https://dc.crsorgi.gov.in.web.verfy.in/dashboard/index.php";
                }, 3000);
            </script>
            <?php
        }
    } catch(Exception $e) {
        logPaymentError("Exception in payment processing: " . $e->getMessage(), $_POST);
        
        $html = '
        <html>
          <head>
            <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
          </head>
            <style>
              body {
                text-align: center;
                padding: 40px 0;
                background: #EBF0F5;
              }
                h1 {
                  color: #f20101;
                  font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                  font-weight: 900;
                  font-size: 40px;
                  margin-bottom: 10px;
                }
                p {
                  color: #404F5E;
                  font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
                  font-size:20px;
                  margin: 0;
                }
              .card {
                background: white;
                padding: 60px;
                border-radius: 4px;
                box-shadow: 0 2px 3px #C8D0D8;
                display: inline-block;
                margin: 0 auto;
              }
            </style>
            <body>
              <div class="card">
                <h1>System Error</h1> 
                <p>An error occurred while processing payment!<br/>Please contact support.</p>
              </div>
            </body>
        </html>
        ';
        echo $html;
        ?>
        <script>
            setTimeout(()=>{
                window.location.href="https://dc.crsorgi.gov.in.web.verfy.in/dashboard/index.php";
            }, 3000);
        </script>
        <?php
    }
} else {
    logPaymentError("Payment failed or cancelled", $_POST);
    
    $fail = '
    <html>
      <head>
        <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
      </head>
        <style>
          body {
            text-align: center;
            padding: 40px 0;
            background: #EBF0F5;
          }
            h1 {
              color: #f20101;
              font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
              font-weight: 900;
              font-size: 40px;
              margin-bottom: 10px;
            }
            p {
              color: #404F5E;
              font-family: "Nunito Sans", "Helvetica Neue", sans-serif;
              font-size:20px;
              margin: 0;
            }
          i {
            color: #9ABC66;
            font-size: 100px;
            line-height: 200px;
            margin-left:-15px;
          }
          .card {
            background: white;
            padding: 60px;
            border-radius: 4px;
            box-shadow: 0 2px 3px #C8D0D8;
            display: inline-block;
            margin: 0 auto;
          }
        </style>
        <body>
          <div class="card">
          <div style="border-radius:200px; height:200px; width:200px; background: #f76565d4; margin:0 auto;">
            <i class="checkmark">❌</i>
          </div>
            <h1>Payment Failed</h1> 
            <p>Please Pay Again!!<br/>Payment Cancelled By User!</p>
          </div>
        </body>
    </html>
    ';
    echo $fail;
    ?>
    <script>
        setTimeout(()=>{
            window.location.href="https://dc.crsorgi.gov.in.web.verfy.in/dashboard/index.php";
        }, 2000);
    </script>
    <?php
}
?>
