<?php
session_start();

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/payment_errors.log');

include_once('../config.php');

// Function to log errors
function logPaymentInitError($message, $data = array()) {
    $logMessage = date('Y-m-d H:i:s') . " - INIT ERROR - " . $message . " - " . json_encode($data) . "\n";
    error_log($logMessage, 3, __DIR__ . '/payment_errors.log');
}

try {
    // Validate required parameters
    if(!isset($_GET['searchid']) || empty($_GET['searchid'])) {
        throw new Exception("Search ID is required");
    }
    
    if(!isset($_SESSION['userid']) || empty($_SESSION['userid'])) {
        throw new Exception("User not logged in");
    }
    
    // Store session variables
    $_SESSION['return_url'] = isset($_GET['return_url']) ? $_GET['return_url'] : '';
    $_SESSION['parent'] = isset($_GET['parent']) ? $_GET['parent'] : '';
    $_SESSION['parent_column_name'] = isset($_GET['parent_column_name']) ? $_GET['parent_column_name'] : '';
    
    // Sanitize inputs
    $searchid = mysqli_real_escape_string($connection, $_GET['searchid']);
    $userId = mysqli_real_escape_string($connection, $_SESSION['userid']);
    
    // Validate connection
    if(!$connection || mysqli_connect_errno()) {
        throw new Exception("Database connection failed: " . mysqli_connect_error());
    }
    
    // Start transaction
    mysqli_begin_transaction($connection);
    
    try {
        // Insert order with proper error handling
        $query = "INSERT INTO orders (user_id, aadharauto_id, amount, created_time, payment_status) 
                  VALUES('$userId', '$searchid', '" . PAYMENT_AMOUNT . "', NOW(), 'PENDING')";
        
        if(!mysqli_query($connection, $query)) {
            throw new Exception("Failed to create order: " . mysqli_error($connection));
        }
        
        $orderId = mysqli_insert_id($connection);
        
        if(!$orderId) {
            throw new Exception("Failed to get order ID");
        }
        
        // Commit the order insertion
        mysqli_commit($connection);
        
        // Log order creation
        error_log(date('Y-m-d H:i:s') . " - Order created - ID: $orderId, UserID: $userId, Amount: " . PAYMENT_AMOUNT . "\n", 3, __DIR__ . '/payment_success.log');
        
    } catch(Exception $e) {
        mysqli_rollback($connection);
        throw $e;
    }
    
    // Load Paytm library
    require_once '../paytm_kit/lib/encdec_paytm.php';
    
    // Prepare email
    $emailId = 'asadhar@newprint.in';
    if (isset($_SESSION['emailid']) && !empty($_SESSION['emailid'])) {
        $emailId = $_SESSION['emailid'];
    }
    
    // Validate required constants
    if(!defined('MID') || !defined('M_KEY') || !defined('WEBSITE_GATEWAY') || !defined('PAYTM_TXN_URL')) {
        throw new Exception("Payment gateway configuration missing");
    }
    
    // Prepare Paytm parameters
    $paytmParams = array(
        "MID" => MID,
        "WEBSITE" => WEBSITE_GATEWAY,
        "INDUSTRY_TYPE_ID" => INDUSTRY_TYPE_ID,
        "CHANNEL_ID" => CHANNEL_ID,
        "ORDER_ID" => ORDER_ID_PREFIX . $searchid . '-' . $orderId,
        "CUST_ID" => $_SESSION['userid'],
        "MOBILE_NO" => isset($_SESSION['mobileno']) ? $_SESSION['mobileno'] : '',
        "EMAIL" => $emailId,
        "TXN_AMOUNT" => (float) PAYMENT_AMOUNT,
        "CALLBACK_URL" => $_SESSION['baseurl'] . '/payment/response.php',
    );
    
    // Generate checksum
    $checksum = getChecksumFromArray($paytmParams, M_KEY);
    
    if(!$checksum) {
        throw new Exception("Failed to generate payment checksum");
    }
    
    // Log payment initialization
    error_log(date('Y-m-d H:i:s') . " - Payment initiated - OrderID: " . $paytmParams['ORDER_ID'] . ", Amount: " . PAYMENT_AMOUNT . "\n", 3, __DIR__ . '/payment_success.log');
    
} catch(Exception $e) {
    // Log error
    logPaymentInitError($e->getMessage(), array(
        'searchid' => isset($_GET['searchid']) ? $_GET['searchid'] : 'N/A',
        'userid' => isset($_SESSION['userid']) ? $_SESSION['userid'] : 'N/A'
    ));
    
    // Redirect to error page
    $returnUrl = isset($_SESSION['return_url']) ? $_SESSION['return_url'] : '/dashboard/index.php';
    header("location: " . $returnUrl . "?error=payment_init_failed&message=" . urlencode($e->getMessage()));
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processing Payment</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            text-align: center;
        }
        h1 {
            color: #333;
            margin-bottom: 20px;
        }
        .loader {
            border: 5px solid #f3f3f3;
            border-top: 5px solid #667eea;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        p {
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Processing Your Payment</h1>
        <div class="loader"></div>
        <p>Please do not refresh or close this page...</p>
        <p>You will be redirected to the payment gateway shortly.</p>
    </div>
    
    <form method="post" action="<?php echo PAYTM_TXN_URL; ?>" name="paytm_form" id="paytm_form">
        <?php
        foreach ($paytmParams as $name => $value) {
            echo '<input type="hidden" name="' . htmlspecialchars($name) . '" value="' . htmlspecialchars($value) . '">';
        }
        ?>
        <input type="hidden" name="CHECKSUMHASH" value="<?php echo $checksum; ?>">
    </form>
    
    <script type="text/javascript">
        // Auto-submit form after 1 second
        setTimeout(function() {
            document.getElementById('paytm_form').submit();
        }, 1000);
    </script>
</body>
</html>
