<?php
session_start();
include_once('../config.php');

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/payment_errors.log');

// Function to log errors
function logError($message, $data = array()) {
    $logMessage = date('Y-m-d H:i:s') . " - " . $message . " - " . json_encode($data) . "\n";
    error_log($logMessage, 3, __DIR__ . '/payment_errors.log');
}

try {
    // Validate required POST data
    if(!isset($_POST['ORDERID']) || empty($_POST['ORDERID'])) {
        throw new Exception("Order ID missing");
    }
    
    $orderId = mysqli_real_escape_string($connection, $_POST['ORDERID']);
    
    $orderArr = explode('-', $orderId);
    
    if(count($orderArr) < 3) {
        throw new Exception("Invalid Order ID format: " . $orderId);
    }
    
    $orderDbId = mysqli_real_escape_string($connection, $orderArr[2]);
    $parentId = mysqli_real_escape_string($connection, $orderArr[1]);
    
    $paymentStatus = isset($_POST['STATUS']) ? mysqli_real_escape_string($connection, $_POST['STATUS']) : '';
    $paymentMode = isset($_POST['PAYMENTMODE']) ? mysqli_real_escape_string($connection, $_POST['PAYMENTMODE']) : '';
    $gatewayResponse = mysqli_real_escape_string($connection, json_encode($_POST));
    
    // Start transaction
    mysqli_begin_transaction($connection);
    
    try {
        if ($paymentStatus == 'TXN_SUCCESS') {
            // Update orders table
            $orderQueryUpdate = "UPDATE orders 
                SET payment_status = 'SUCCESS', 
                    payment_mode = '$paymentMode', 
                    gateway_response = '$gatewayResponse',
                    updated_at = NOW()
                WHERE id = '$orderDbId'";
            
            if(!mysqli_query($connection, $orderQueryUpdate)) {
                throw new Exception("Failed to update orders table: " . mysqli_error($connection));
            }
            
            // Update parent table if session data exists
            if(isset($_SESSION['parent']) && isset($_SESSION['parent_column_name'])) {
                $parentTable = mysqli_real_escape_string($connection, $_SESSION['parent']);
                $parentColumnName = mysqli_real_escape_string($connection, $_SESSION['parent_column_name']);
                
                $parentTableUpdate = "UPDATE $parentTable 
                    SET payment_status = '1', 
                        updated_at = NOW() 
                    WHERE $parentColumnName = '$parentId'";
                
                if(!mysqli_query($connection, $parentTableUpdate)) {
                    throw new Exception("Failed to update parent table: " . mysqli_error($connection));
                }
            }
            
            // Commit transaction
            mysqli_commit($connection);
            
            // Log success
            error_log(date('Y-m-d H:i:s') . " - Payment SUCCESS - OrderID: $orderId\n", 3, __DIR__ . '/payment_success.log');
            
        } else {
            // Payment failed or pending
            $orderQueryUpdate = "UPDATE orders 
                SET payment_status = '$paymentStatus',
                    payment_mode = '$paymentMode', 
                    gateway_response = '$gatewayResponse',
                    updated_at = NOW()
                WHERE id = '$orderDbId'";
            
            if(!mysqli_query($connection, $orderQueryUpdate)) {
                throw new Exception("Failed to update orders table for failed payment: " . mysqli_error($connection));
            }
            
            mysqli_commit($connection);
            
            // Log failed payment
            logError("Payment FAILED/PENDING", array(
                'orderId' => $orderId,
                'status' => $paymentStatus,
                'response' => $_POST
            ));
        }
        
        // Redirect to return URL
        $returnUrl = isset($_SESSION['return_url']) ? $_SESSION['return_url'] : '/dashboard/index.php';
        header("location: " . $returnUrl);
        exit;
        
    } catch(Exception $e) {
        // Rollback on error
        mysqli_rollback($connection);
        throw $e;
    }
    
} catch(Exception $e) {
    // Log critical error
    logError("Critical error in payment-response.php: " . $e->getMessage(), array(
        'post_data' => $_POST,
        'session_data' => array(
            'userid' => isset($_SESSION['userid']) ? $_SESSION['userid'] : 'N/A',
            'return_url' => isset($_SESSION['return_url']) ? $_SESSION['return_url'] : 'N/A'
        )
    ));
    
    // Redirect to error page or dashboard
    $returnUrl = isset($_SESSION['return_url']) ? $_SESSION['return_url'] . '?error=payment_processing_failed' : '/dashboard/index.php?error=payment_processing_failed';
    header("location: " . $returnUrl);
    exit;
}
?>
