-- Database table to track payment transactions and prevent duplicates

CREATE TABLE IF NOT EXISTS `payment_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(100) NOT NULL,
  `order_id` varchar(100) NOT NULL,
  `bank_txn_id` varchar(100) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `txn_status` varchar(50) DEFAULT NULL,
  `txn_date` varchar(50) DEFAULT NULL,
  `response_data` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_transaction` (`order_id`, `bank_txn_id`),
  KEY `user_id` (`user_id`),
  KEY `order_id` (`order_id`),
  KEY `bank_txn_id` (`bank_txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add index for faster lookups
CREATE INDEX idx_user_created ON payment_transactions(user_id, created_at);
