<?php
error_reporting(0);

// Direct database connection (update with your credentials)
$servername = "localhost";
$username = "verfysr_crs";  // Update this with your actual DB username
$password = "verfysr_crs";  // Update this with your actual DB password
$dbname = "verfysr_crs";  // Update this with your actual DB name

$connection = new mysqli($servername, $username, $password, $dbname);
if ($connection->connect_error) {
    error_log("Database connection failed: " . $connection->connect_error);
    die("Database connection failed");
}

// Payment gateway secret key
$secret = 'EWNd1pUfXi';

// Log all received data
error_log("Payment Response Data: " . print_r($_POST, true));

// Get POST data
$status = isset($_POST['status']) ? $_POST['status'] : '';
$txnAmount = isset($_POST['txnAmount']) ? $_POST['txnAmount'] : '';
$message = isset($_POST['message']) ? $_POST['message'] : '';
$hash = isset($_POST['hash']) ? $_POST['hash'] : '';
$orderId = isset($_POST['orderId']) ? $_POST['orderId'] : '';

// Try to get userid from different sources
$userid = '';
if(isset($_POST['sender_note']) && !empty($_POST['sender_note'])) {
    $userid = $_POST['sender_note'];
} elseif(isset($_POST['txnNote']) && !empty($_POST['txnNote'])) {
    $userid = $_POST['txnNote'];
} elseif(isset($_POST['custId']) && !empty($_POST['custId'])) {
    $userid = $_POST['custId'];
}

error_log("Extracted - Status: $status, Amount: $txnAmount, UserID: $userid, OrderID: $orderId");

// Process successful payment
if($status == "SUCCESS" && !empty($userid) && !empty($txnAmount)) {
    
    // Update user wallet
    $sql = "UPDATE usertable SET walletamount = walletamount + " . floatval($txnAmount) . " WHERE userid = '" . mysqli_real_escape_string($connection, $userid) . "'";
    $res = mysqli_query($connection, $sql);
    
    if($res) {
        error_log("Wallet updated successfully for user: $userid");
        
        // Check if payment_transactions table exists, if not create it
        $checkTable = "SHOW TABLES LIKE 'payment_transactions'";
        $tableExists = mysqli_query($connection, $checkTable);
        
        if(!$tableExists || mysqli_num_rows($tableExists) == 0) {
            $createTable = "CREATE TABLE IF NOT EXISTS `payment_transactions` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `userid` varchar(50) NOT NULL,
                `amount` decimal(10,2) NOT NULL,
                `order_id` varchar(100) DEFAULT NULL,
                `status` enum('SUCCESS','FAILED','PENDING') DEFAULT 'SUCCESS',
                `gateway_response` text,
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
            mysqli_query($connection, $createTable);
        }
        
        // Insert transaction record
        $insertSql = "INSERT INTO payment_transactions (userid, amount, order_id, status, gateway_response) 
                     VALUES ('" . mysqli_real_escape_string($connection, $userid) . "', 
                             '" . floatval($txnAmount) . "', 
                             '" . mysqli_real_escape_string($connection, $orderId) . "', 
                             'SUCCESS', 
                             '" . mysqli_real_escape_string($connection, json_encode($_POST)) . "')";
        mysqli_query($connection, $insertSql);
        
        // Success Response
        echo '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Payment Successful</title>
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
    <style>
        body {
            text-align: center;
            padding: 40px 0;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-family: "Nunito Sans", sans-serif;
            min-height: 100vh;
            margin: 0;
        }
        .card {
            background: white;
            padding: 60px;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            display: inline-block;
            margin: 0 auto;
            max-width: 500px;
            animation: bounceIn 0.6s ease-out;
        }
        @keyframes bounceIn {
            0% { transform: scale(0.3); opacity: 0; }
            50% { transform: scale(1.05); }
            70% { transform: scale(0.9); }
            100% { transform: scale(1); opacity: 1; }
        }
        .success-icon {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            background: linear-gradient(135deg, #4CAF50, #45a049);
            margin: 0 auto 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 60px;
            color: white;
            box-shadow: 0 8px 25px rgba(76, 175, 80, 0.3);
        }
        h1 {
            color: #4CAF50;
            font-size: 36px;
            margin-bottom: 20px;
            font-weight: 900;
        }
        .amount {
            font-size: 32px;
            color: #2E7D32;
            font-weight: bold;
            margin: 20px 0;
            padding: 15px;
            background: #E8F5E8;
            border-radius: 10px;
        }
        .details {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            border-left: 4px solid #4CAF50;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin: 10px 0;
            font-size: 16px;
        }
        .detail-label {
            font-weight: 600;
            color: #555;
        }
        .detail-value {
            color: #333;
        }
        .redirect-info {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            color: #856404;
        }
        .btn {
            background: #4CAF50;
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 10px;
            transition: all 0.3s ease;
        }
        .btn:hover {
            background: #45a049;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(76, 175, 80, 0.3);
        }
        .countdown {
            font-size: 18px;
            font-weight: 600;
            color: #666;
            margin: 20px 0;
        }
        #countdown-number {
            color: #4CAF50;
            font-size: 24px;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="success-icon">✓</div>
        <h1>Payment Successful!</h1>
        <div class="amount">₹' . $txnAmount . '</div>
        
        <div class="details">
            <div class="detail-row">
                <span class="detail-label">User ID:</span>
                <span class="detail-value">' . $userid . '</span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Order ID:</span>
                <span class="detail-value">' . $orderId . '</span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Date & Time:</span>
                <span class="detail-value">' . date('d-m-Y H:i:s') . '</span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Status:</span>
                <span class="detail-value" style="color: #4CAF50; font-weight: bold;">Completed</span>
            </div>
        </div>
        
        <p style="color: #4CAF50; font-size: 18px; font-weight: 600;">
            🎉 Your wallet has been credited successfully!
        </p>
        
        <div class="redirect-info">
            <div class="countdown">
                Redirecting to your wallet in <span id="countdown-number">5</span> seconds...
            </div>
        </div>
        
        <a href="https://dc.crsorgi.gov.in.web.verfy.in/wallet.php" class="btn">
            View Wallet Now
        </a>
    </div>
    
    <script>
        let timeLeft = 5;
        const countdownElement = document.getElementById("countdown-number");
        
        const timer = setInterval(() => {
            timeLeft--;
            countdownElement.textContent = timeLeft;
            
            if (timeLeft <= 0) {
                clearInterval(timer);
                window.location.href = "https://dc.crsorgi.gov.in.web.verfy.in/wallet.php";
            }
        }, 1000);
    </script>
</body>
</html>';
        
        exit;
    } else {
        error_log("Database update failed for user: $userid");
    }
}

// Payment failed or incomplete data
error_log("Payment processing failed - Status: $status, UserID: $userid, Amount: $txnAmount");

// Insert failed transaction record if we have some data
if(!empty($userid) || !empty($orderId)) {
    $checkTable = "SHOW TABLES LIKE 'payment_transactions'";
    $tableExists = mysqli_query($connection, $checkTable);
    
    if(!$tableExists || mysqli_num_rows($tableExists) == 0) {
        $createTable = "CREATE TABLE IF NOT EXISTS `payment_transactions` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `userid` varchar(50) NOT NULL,
            `amount` decimal(10,2) NOT NULL,
            `order_id` varchar(100) DEFAULT NULL,
            `status` enum('SUCCESS','FAILED','PENDING') DEFAULT 'FAILED',
            `gateway_response` text,
            `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
        mysqli_query($connection, $createTable);
    }
    
    $insertSql = "INSERT INTO payment_transactions (userid, amount, order_id, status, gateway_response) 
                 VALUES ('" . mysqli_real_escape_string($connection, $userid ? $userid : 'UNKNOWN') . "', 
                         '" . floatval($txnAmount ? $txnAmount : 0) . "', 
                         '" . mysqli_real_escape_string($connection, $orderId) . "', 
                         'FAILED', 
                         '" . mysqli_real_escape_string($connection, json_encode($_POST)) . "')";
    mysqli_query($connection, $insertSql);
}

// Failed Payment Response
echo '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Payment Failed</title>
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,400i,700,900&display=swap" rel="stylesheet">
    <style>
        body {
            text-align: center;
            padding: 40px 0;
            background: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%);
            font-family: "Nunito Sans", sans-serif;
            min-height: 100vh;
            margin: 0;
        }
        .card {
            background: white;
            padding: 60px;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            display: inline-block;
            margin: 0 auto;
            max-width: 500px;
        }
        .error-icon {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            background: linear-gradient(135deg, #e74c3c, #c0392b);
            margin: 0 auto 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 60px;
            color: white;
        }
        h1 {
            color: #e74c3c;
            font-size: 36px;
            margin-bottom: 20px;
            font-weight: 900;
        }
        .btn {
            background: #3498db;
            color: white;
            border: none;
            padding: 15px 30px;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 10px;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="error-icon">✗</div>
        <h1>Payment Failed</h1>
        <p style="font-size: 18px; color: #666; margin: 20px 0;">
            ' . ($status == 'FAILED' ? 'Your payment could not be processed.' : 'Payment verification failed.') . '
        </p>
        <p style="color: #999;">
            Status: ' . $status . '<br>
            Message: ' . $message . '
        </p>
        <a href="https://dc.crsorgi.gov.in.web.verfy.in/index.php" class="btn">
            Try Again
        </a>
    </div>
    
    <script>
        setTimeout(() => {
            window.location.href = "https://dc.crsorgi.gov.in.web.verfy.in/index.php";
        }, 5000);
    </script>
</body>
</html>';
?>