<?php
// Debug file to test payment configuration
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Try different config paths
$config_paths = [
    '../config.php',
    '../../config.php',
    '../../../config.php',
    './config.php',
    '../config.php',
    '../../config.php'
];

$config_loaded = false;
foreach($config_paths as $path) {
    if(file_exists($path)) {
        include $path;
        $config_loaded = true;
        echo "<p style='color: green;'>✅ Config loaded from: " . $path . "</p>";
        break;
    }
}

if(!$config_loaded) {
    echo "<p style='color: red;'>❌ Config.php not found. Tested paths:</p>";
    echo "<ul>";
    foreach($config_paths as $path) {
        echo "<li>" . $path . " - " . (file_exists($path) ? "EXISTS" : "NOT FOUND") . "</li>";
    }
    echo "</ul>";
    
    // Show current directory structure
    echo "<h4>Current Directory Contents:</h4>";
    echo "<ul>";
    $files = scandir('.');
    foreach($files as $file) {
        if($file != '.' && $file != '..') {
            echo "<li>" . $file . (is_dir($file) ? " (DIR)" : "") . "</li>";
        }
    }
    echo "</ul>";
    
    echo "<h4>Parent Directory Contents:</h4>";
    echo "<ul>";
    if(is_dir('../')) {
        $files = scandir('../');
        foreach($files as $file) {
            if($file != '.' && $file != '..') {
                echo "<li>../" . $file . (is_dir('../' . $file) ? " (DIR)" : "") . "</li>";
            }
        }
    }
    echo "</ul>";
}

require_once('lib/Config_HBConnect.php');
require_once('lib/RechPayChecksum.php');

echo "<h2>Payment Configuration Debug</h2>";

echo "<h3>1. Configuration Values:</h3>";
echo "UPI UID: " . $upiuid . "<br>";
echo "Token: " . $token . "<br>";
echo "Secret: " . $secret . "<br>";
echo "Callback URL: " . $callback_url . "<br>";
echo "Gateway URL: " . $RECHPAY_TXN_URL . "<br>";

echo "<h3>2. POST Data Received:</h3>";
echo "<pre>";
print_r($_POST);
echo "</pre>";

echo "<h3>3. Test Parameters:</h3>";
$testParams = array(
    "upiuid" => $upiuid,
    "token" => $token,
    "orderId" => time(),
    "txnAmount" => "99",
    "txnNote" => "TEST123",
    "cust_Mobile" => "9876543210",
    "cust_Email" => "test@example.com",
    "callback_url" => $callback_url,
    "sender_note" => "TEST123"
);

echo "<pre>";
print_r($testParams);
echo "</pre>";

echo "<h3>4. Generate Test Checksum:</h3>";
$testChecksum = RechPayChecksum::generateSignature($testParams, $secret);
echo "Generated Checksum: " . $testChecksum . "<br>";

echo "<h3>5. Test Hash Decrypt (if hash provided):</h3>";
if(isset($_POST['hash']) && !empty($_POST['hash'])) {
    $decrypted = hash_decrypt($_POST['hash'], $secret);
    echo "Decrypted Hash: <pre>" . $decrypted . "</pre>";
    
    if($decrypted) {
        $array = json_decode($decrypted, true);
        echo "Parsed Array: <pre>";
        print_r($array);
        echo "</pre>";
    }
}

echo "<h3>6. Test Form for Manual Payment:</h3>";
?>
<form method="post" action="index.php" style="background: #f0f0f0; padding: 20px; margin: 20px 0;">
    <h4>Test Payment Form:</h4>
    <input type="hidden" name="amount" value="99">
    <input type="hidden" name="userid" value="9876543210">
    <input type="hidden" name="email" value="test@example.com">
    <input type="hidden" name="mobile" value="9876543210">
    
    <p>Amount: ₹99</p>
    <p>User ID: 9876543210</p>
    <p>Email: test@example.com</p>
    
    <button type="submit" style="background: #007cba; color: white; padding: 10px 20px; border: none; cursor: pointer;">
        Test Payment
    </button>
</form>

<?php
echo "<h3>7. Database Connection Test:</h3>";
if(isset($connection)) {
    if(mysqli_ping($connection)) {
        echo "✅ Database connection is active<br>";
        
        // Test usertable
        $testQuery = "SELECT userid, walletamount FROM usertable LIMIT 1";
        $result = mysqli_query($connection, $testQuery);
        if($result) {
            echo "✅ usertable is accessible<br>";
        } else {
            echo "❌ usertable error: " . mysqli_error($connection) . "<br>";
        }
        
        // Test payment_transactions table
        $testQuery2 = "SHOW TABLES LIKE 'payment_transactions'";
        $result2 = mysqli_query($connection, $testQuery2);
        if($result2 && mysqli_num_rows($result2) > 0) {
            echo "✅ payment_transactions table exists<br>";
        } else {
            echo "❌ payment_transactions table not found<br>";
            echo "Please create the table using the SQL provided earlier.<br>";
        }
        
    } else {
        echo "❌ Database connection failed<br>";
    }
} else {
    echo "❌ Database connection variable not found<br>";
}

echo "<h3>8. File Permissions:</h3>";
echo "Current file: " . __FILE__ . "<br>";
echo "Writable: " . (is_writable(dirname(__FILE__)) ? "Yes" : "No") . "<br>";
echo "Config file exists: " . (file_exists('lib/Config_HBConnect.php') ? "Yes" : "No") . "<br>";
echo "Checksum file exists: " . (file_exists('lib/RechPayChecksum.php') ? "Yes" : "No") . "<br>";

?>

<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    h2 { color: #007cba; }
    h3 { color: #333; border-bottom: 1px solid #ccc; }
    pre { background: #f5f5f5; padding: 10px; border-radius: 5px; }
</style>