<?php
// add_wallet.php
session_start();
include('header.php');
include('config.php');

// --- Make sure these variables exist (from your login/session logic) ---
$useremail = isset($useremail) ? $useremail : (isset($_SESSION['useremail']) ? $_SESSION['useremail'] : '');
$userphone = isset($userphone) ? $userphone : (isset($_SESSION['userphone']) ? $_SESSION['userphone'] : '');
$username  = isset($username)  ? $username  : (isset($_SESSION['username'])  ? $_SESSION['username']  : '');
$usertype  = isset($usertype)  ? $usertype  : (isset($_SESSION['usertype'])  ? $_SESSION['usertype']  : '');
$userid    = isset($userid)    ? $userid    : (isset($_SESSION['userid'])    ? $_SESSION['userid']    : '0');

// Save back to session (as in your original)
$_SESSION['useremail'] = $useremail;
$_SESSION['userphone'] = $userphone;
$_SESSION['username']  = $username;
$_SESSION['usertype']  = $usertype;
$_SESSION['userid']    = $userid;
?>
<!-- Optional: If your header.php does not include these, they are here as fallback -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="" crossorigin="anonymous" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
/* Small custom styles to make page look neat */
.wallet-card { border-radius: 12px; box-shadow: 0 6px 18px rgba(49,210,224,0.12); }
.icon-circle { width:48px; height:48px; border-radius:50%; display:flex; align-items:center; justify-content:center; background:#f0f8ff; font-size:20px; }
.select-amount { font-weight:600; }
.note-box { border-left: 4px solid #31d2e0; padding:12px; background:#f8fbfc; border-radius:6px; }
.small-muted { font-size:0.9rem; color:#6c757d; }
</style>

<div class="container my-4">
  <div class="row">
    <div class="col-md-10 offset-md-1">
      <div class="card wallet-card p-3">
        <div class="d-flex align-items-center mb-3">
          <div class="icon-circle mr-3"><i class="fa-solid fa-wallet"></i></div>
          <div>
            <h4 class="mb-0">Add Wallet Balance</h4>
            <small class="small-muted">Recharge instantly using the payment gateway</small>
          </div>
          <div class="ml-auto text-right">
            <a href="index.php" class="btn btn-sm btn-light"><i class="fa-solid fa-arrow-left"></i> Back</a>
          </div>
        </div>

        <!-- Transaction status popups (same logic as before) -->
        <?php if(isset($_GET['txn_status']) && $_GET['txn_status'] =='SUCCESS'): ?>
          <script>
            document.addEventListener('DOMContentLoaded', function(){
              Swal.fire('Success', 'Recharge Successful', 'success');
            });
          </script>
        <?php elseif(isset($_GET['txn_status']) && ($_GET['txn_status'] =='FAILED' || $_GET['txn_status'] =='TXN_FAILED')): ?>
          <script>
            document.addEventListener('DOMContentLoaded', function(){
              Swal.fire('Failed', 'Recharge Failed. Please try again or contact support.', 'error');
            });
          </script>
        <?php endif; ?>

        <div class="card-body">
          <div class="row">
            <div class="col-md-6 border-right">
              <h5 class="mb-3">Quick Recharge</h5>

              <form method="post" action="payment/index.php" id="walletForm" novalidate>
                <!-- hidden fields -->
                <input type="hidden" name="userid" value="<?php echo htmlspecialchars($userid); ?>">
                <input type="hidden" name="phone" value="<?php echo htmlspecialchars($userphone); ?>">
                <input type="hidden" name="emailid" value="<?php echo htmlspecialchars($useremail); ?>">

                <div class="form-group">
                  <label for="amount" class="font-weight-bold">Choose Amount <span class="text-danger">*</span></label>
                  <select required class="form-control select-amount" name="amount" id="amount">
                    <option value="">Select Amount</option>
                    <option value="100">₹100</option>
                    <option value="200">₹200</option>
                    <option value="500">₹500</option>
                    <option value="1000">₹1000</option>
                    <option value="2000">₹2000</option>
                  </select>
                </div>

                <div class="form-group">
                  <label class="font-weight-bold">Pay With</label>
                  <div>
                    <span class="mr-2"><i class="fa-brands fa-google-pay fa-lg"></i></span>
                    <span class="mr-2"><i class="fa-brands fa-apple-pay fa-lg"></i></span>
                    <span class="mr-2"><i class="fa-brands fa-cc-visa fa-lg"></i></span>
                    <span class="mr-2"><i class="fa-brands fa-cc-mastercard fa-lg"></i></span>
                  </div>
                </div>

                <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-block">
                    <i class="fa-solid fa-paper-plane"></i> Proceed to Pay
                  </button>
                </div>

                <div class="form-group small-muted text-center">
                  <i class="fa-solid fa-lock"></i> Secure payment. You will be redirected to the payment gateway.
                </div>
              </form>
            </div>

            <div class="col-md-6">
              <h5 class="mb-3">Important Notes</h5>

              <div class="note-box mb-3">
                <p class="mb-1"><strong>1.</strong> After a successful payment the amount will be automatically added to your wallet.</p>
                <p class="mb-1"><strong>2.</strong> Do not refresh or close the payment page until the transaction completes.</p>
                <p class="mb-0"><strong>3.</strong> If payment fails, check your bank/app and try again or contact support.</p>
              </div>

              <h6 class="mb-2">Need help?</h6>
              <p class="small-muted mb-2"><i class="fa-solid fa-headset"></i> Join our Telegram: <a href="https://t.me/armitradigital" target="_blank">t.me/armitradigital</a></p>

<!--              <hr>-->

              <!-- Example: Recent Wallet Transactions table (if you have data, hook it up from DB) -->
<!--              <h6 class="mb-2">Recent Transactions</h6>-->
<!--              <div class="table-responsive">-->
<!--                <table id="tb-wallet" class="table table-sm table-striped table-bordered">-->
<!--                  <thead>-->
<!--                    <tr>-->
<!--                      <th>#</th>-->
<!--                      <th>Date</th>-->
<!--                      <th>Amount</th>-->
<!--                      <th>Txn ID</th>-->
<!--                      <th>Status</th>-->
<!--                    </tr>-->
<!--                  </thead>-->
<!--                  <tbody>-->
                    <!-- If you have DB records, loop here. Example placeholders: -->
<!--                    <tr>-->
<!--                      <td>1</td>-->
<!--                      <td>2025-10-08</td>-->
<!--                      <td>₹500</td>-->
<!--                      <td>TXN123456</td>-->
<!--                      <td><span class="badge badge-success"><i class="fa-solid fa-check"></i> Success</span></td>-->
<!--                    </tr>-->
<!--                    <tr>-->
<!--                      <td>2</td>-->
<!--                      <td>2025-09-25</td>-->
<!--                      <td>₹200</td>-->
<!--                      <td>TXN987654</td>-->
<!--                      <td><span class="badge badge-danger"><i class="fa-solid fa-xmark"></i> Failed</span></td>-->
<!--                    </tr>-->
<!--                  </tbody>-->
<!--                </table>-->
<!--              </div>-->

<!--            </div>-->
<!--          </div>-->
<!--        </div> <!-- card-body -->-->
<!--      </div> <!-- card -->-->
<!--    </div>-->
<!--  </div>-->
<!--</div>-->

<!-- Required scripts (if header/footer don't include them) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- SweetAlert2 (used for success/failure) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- DataTables (if you want interactivity on the transactions table) -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css" />
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

<script>
$(document).ready(function(){
  // DataTable init
  if ( $.fn.DataTable ) {
    $('#tb-wallet').DataTable({
      paging: true,
      ordering: true,
      info: false,
      searching: false,
      responsive: true
    });
  }

  // simple client-side validation for demo (server-side must still validate)
  $('#walletForm').on('submit', function(e){
    var amount = $('#amount').val();
    if (!amount) {
      e.preventDefault();
      Swal.fire('Select Amount', 'Please choose an amount to proceed.', 'warning');
      return false;
    }
    // allow submit — actual payment handled by payment/index.php
  });

  // Disable right-click message still optional; prefer not to disable for accessibility.
  // If you want to re-enable old script, uncomment below:
  /*
  document.oncontextmenu = function() { Swal.fire('Notice','Right Click Disabled','info'); return false; }
  */
});
</script>

<?php
include('userfooter.php');
?>
